function [ cond ] = checkTriangleCondition( points, minLength, minAngle )
%CHECKCOLLINEAR Summary of this function goes here
%   points is 3x3, with each 3x1 vector being a point
%   returns 1 if true, 0 otherwise

vec1 = points(:,2)-points(:,1);
vec2 = points(:,3)-points(:,1);
vec3 = points(:,3)-points(:,2);

d1 = norm(vec1);
d2 = norm(vec2);
d3 = norm(vec3);

if (d1 < minLength) || (d2 < minLength) ||(d3 < minLength)
    cond = 0;
    return;
else
    cond = 1;
end

t1 = acosd(dot(vec1,vec2)/(d1*d2));
t2 = acosd(dot(vec2,vec3)/(d2*d3));
t3 = acosd(dot(vec3,vec1)/(d3*d1));

if (t1 < minAngle) || (t2 < minAngle) ||(t3 < minAngle)
    cond = 0;
    return;
else
    cond = 1;
end

end

